/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY                          *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public Liense as published by        *
 * the Free Software Foundation, either version 2 of the License, or (at      * 
 * your option) any later version.                                            *
 *                                                                            *
 * The ITX package is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
 * for more details.                                                          * 
 *                                                                            *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.                                                   *
 *                                                                            * 
 * Contact information:                                                       *
 * Donna Bergmark                                                             *
 * 484 Rhodes Hall                                                            *
 * Cornell University                                                         *
 * Ithaca, NY 14853-3801                                                      *
 * bergmark@cs.cornell.edu                                                    *
 ******************************************************************************/
package client;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/** 
 * This class implements a Swing dialog box for obtaining ITX username and
 * password from the user, as well as an optional telephone number.
 * 
 * @version 1.0, 12/15/1998
 * @author Jason Howes
 */
public class ClientLoginGUI extends JDialog implements ActionListener
{		
	/**
	 * User specified an ITX destination
	 */
	private boolean mDestinationSpecified = false;
	
	/**
	 * User logged in
	 */
	private boolean mUserLoggedIn = false;
	
	/** 
	 * Dialog defaults
	 */
	private final static String DIALOG_NAME			= "SPOT Login";

	/** 
	 * Application labels
	 */
	private final static JLabel ID_LABEL			= new JLabel("User ID:");
	private final static JLabel PASSWORD_LABEL		= new JLabel("User password:");
	
	/** 
	 * Component commands
	 */
	private final static String LOGIN_COMMAND		= "Login";
	private final static String CANCEL_COMMAND		= "Cancel";
	private final static String CLIENT_COMMAND		= "SPOT Client";
	private final static String USER_COMMAND		= "ITX User";
	
	/**
	 * Login GUI components 
	 */
	private JTextField textUserID;
	private JPasswordField textUserPassword;
	private JTextField textDestinationID;
	
	private JButton buttonLogin;
	private JButton buttonCancel;
	
	private JRadioButton radioSPOTClient;
	private JRadioButton radioITXUser;
	
	private JPanel loginPanel;
	private JPanel connectionPanel;
	private JPanel buttonPanel;
	
	/**
	 * Class constructor
	 */
	public ClientLoginGUI()
	{
		super(JOptionPane.getRootFrame(), DIALOG_NAME, true);
		
		// Get our content pane
		JPanel contentPane = (JPanel)getContentPane();
		
		// Create and layout the login panel
		loginPanel = new JPanel();
		GridBagLayout loginLayout = new GridBagLayout();
		GridBagConstraints loginConstraints = new GridBagConstraints();
		loginPanel.setLayout(loginLayout);
		loginPanel.setBorder(BorderFactory.createCompoundBorder(
			BorderFactory.createEmptyBorder(5, 5, 5, 5),
			BorderFactory.createCompoundBorder(																
				BorderFactory.createTitledBorder("ITX User Login:"),
				BorderFactory.createEmptyBorder(5, 5, 5, 5))));		
		
		textUserID = new JTextField(15);
		textUserPassword = new JPasswordField(15);
		
		// Set constraints for all the labels
		loginConstraints.gridwidth = GridBagConstraints.RELATIVE;
		loginConstraints.anchor = GridBagConstraints.WEST;
		loginConstraints.fill = GridBagConstraints.NONE;
		loginConstraints.insets = new Insets(5, 0, 0, 0);
		loginConstraints.weightx = 0.0;
		
		loginLayout.setConstraints(ID_LABEL, loginConstraints);
		loginLayout.setConstraints(PASSWORD_LABEL, loginConstraints); 
		
		// Set constraints for all the labeled components
		loginConstraints.gridwidth = GridBagConstraints.REMAINDER;
		loginConstraints.anchor = GridBagConstraints.EAST;
		loginConstraints.fill = GridBagConstraints.HORIZONTAL;
		loginConstraints.weightx = 1.0;
		
		loginLayout.setConstraints(textUserID, loginConstraints);
		loginLayout.setConstraints(textUserPassword, loginConstraints);
		
		// Add all components
		loginPanel.add(ID_LABEL);
		loginPanel.add(textUserID);
		loginPanel.add(PASSWORD_LABEL);
		loginPanel.add(textUserPassword);
		
		// Create and layout the connection panel 
		connectionPanel = new JPanel();
		GridBagLayout connectionLayout = new GridBagLayout();
		GridBagConstraints connectionConstraints = new GridBagConstraints();
		connectionPanel.setLayout(connectionLayout);		
		connectionPanel.setBorder(BorderFactory.createCompoundBorder(
			BorderFactory.createEmptyBorder(5, 5, 5, 5),
			BorderFactory.createCompoundBorder(
				BorderFactory.createTitledBorder("Audio Connection:"),
				BorderFactory.createEmptyBorder(5, 5, 5, 5))));			
		
		radioSPOTClient = new JRadioButton("SPOT client");
        radioSPOTClient.setSelected(true);
		radioSPOTClient.setActionCommand(CLIENT_COMMAND);
		radioSPOTClient.addActionListener(this);
		radioITXUser = new JRadioButton("ITX user:");
		radioITXUser.setActionCommand(USER_COMMAND);
		radioITXUser.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(radioSPOTClient);
        group.add(radioITXUser);		
		JLabel labelBlank = new JLabel();
		textDestinationID = new JTextField(15);
		textDestinationID.setEditable(false);
		
		// Set constraints for all the radio buttons
		connectionConstraints.gridwidth = GridBagConstraints.RELATIVE;
		connectionConstraints.anchor = GridBagConstraints.WEST;
		connectionConstraints.fill = GridBagConstraints.NONE;
		connectionConstraints.weightx = 0.0;
		
		connectionLayout.setConstraints(radioSPOTClient, connectionConstraints);
		connectionLayout.setConstraints(radioITXUser, connectionConstraints);
		
		// Set constraints for the radio button components
		connectionConstraints.gridwidth = GridBagConstraints.REMAINDER;
		connectionConstraints.anchor = GridBagConstraints.EAST;
		connectionConstraints.fill = GridBagConstraints.HORIZONTAL;
		connectionConstraints.weightx = 1.0;
		
		connectionLayout.setConstraints(labelBlank, connectionConstraints);
		connectionLayout.setConstraints(textDestinationID, connectionConstraints);
		
		// Add all components
		connectionPanel.add(radioSPOTClient);
		connectionPanel.add(labelBlank);
		connectionPanel.add(radioITXUser);
		connectionPanel.add(textDestinationID);	
		
		// Create the button panel
		buttonPanel = new JPanel();
		buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
		buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
		
		buttonLogin = new JButton("Login");
		buttonLogin.setActionCommand(LOGIN_COMMAND);
		buttonLogin.addActionListener(this);
		buttonCancel = new JButton("Cancel");
		buttonCancel.setActionCommand(CANCEL_COMMAND);
		buttonCancel.addActionListener(this);
		
		// Add all components
		buttonPanel.add(Box.createHorizontalGlue());
		buttonPanel.add(buttonLogin);
		buttonPanel.add(Box.createHorizontalStrut(5));
		buttonPanel.add(buttonCancel);
		
		// Create and layout the main panel
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
		contentPane.add(loginPanel);
		contentPane.add(connectionPanel);
		contentPane.add(buttonPanel);
		
		// Set ourself as non-resizable, center ourself, and show the dialog
		setResizable(false);
		pack();
		setLocationRelativeTo(null);
		show();
	}
	
	/**
	 * Returns the user ID.
	 */
	public String getUserID()
	{
		return textUserID.getText();
	}
	
	/**
	 * Returns the user password.
	 */
	public String getUserPassword()
	{
		return new String(textUserPassword.getPassword());
	}
	
	/**
	 * Returns the user telephone number.
	 */
	public String getDestinationID()
	{
		return textDestinationID.getText();
	}
	
	/**
	 * Determines if the user specified a destination.
	 */
	public boolean destinationSpecified()
	{
		return mDestinationSpecified;
	}
	
	/**
	 * Determines if the user logged in
	 */
	public boolean userLoggedIn()
	{
		return mUserLoggedIn;
	}
	
	/**
	 * <code>ActionEvent</code> handler.
	 * 
	 * @param e event to handle
	 */
    public void actionPerformed(ActionEvent e) 
	{
		String actionCommand = e.getActionCommand();
		
        if (actionCommand.equals(LOGIN_COMMAND)) 
		{
			mUserLoggedIn = true;
			dispose();
        }
		else if (actionCommand.equals(CANCEL_COMMAND)) 
		{
			mUserLoggedIn = false;
			dispose();
        }
		else if (actionCommand.equals(CLIENT_COMMAND))
		{
			mDestinationSpecified = false;
			textDestinationID.setText("");
			textDestinationID.setEditable(false);
		}
		else if (actionCommand.equals(USER_COMMAND))
		{
			mDestinationSpecified = true;
			textDestinationID.setEditable(true);
		}
    }	
}
